/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.util.ArrayList;
import java.util.Collection;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.ParameterBuilder;

public class FixedNameBuilder
extends ParameterBuilder {
    private final String fixedName;

    public FixedNameBuilder(AICommandParameter annot) {
        super(annot);
        this.fixedName = annot.fixedName();
    }

    @Override
    public void addArguments(ArrayList<ArgumentDefinition> list) {
        list.add(new FixedArgumentDefinition("'" + this.fixedName + "'", "fixed String"));
    }

    @Override
    public Object getParameter(AIHelper helper, String[] arguments) {
        return arguments[0];
    }

    public final class FixedArgumentDefinition
    extends ArgumentDefinition {
        private FixedArgumentDefinition(String descriptionType, String descriptionInfo) {
            super(descriptionType, descriptionInfo);
        }

        @Override
        public void getTabCompleteOptions(String currentStart, Collection<String> addTo) {
            super.getTabCompleteOptions(currentStart, addTo);
            if (FixedNameBuilder.this.fixedName.startsWith(currentStart)) {
                addTo.add(FixedNameBuilder.this.fixedName);
            }
        }

        @Override
        public boolean couldEvaluateAgainst(String string) {
            return string.equals(FixedNameBuilder.this.fixedName);
        }

        public String getFixedName() {
            return FixedNameBuilder.this.fixedName;
        }
    }
}

