/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.util.ArrayList;
import java.util.Collection;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.ParameterBuilder;

public class EnumNameBuilder<T extends Enum<T>>
extends ParameterBuilder {
    private final Class<T> enumClass;

    public EnumNameBuilder(AICommandParameter annot, Class<T> enumClass) {
        super(annot);
        this.enumClass = enumClass;
    }

    @Override
    public void addArguments(ArrayList<ArgumentDefinition> list) {
        list.add(new EnumArgumentDefinition(this.enumClass.getSimpleName(), this.annot.description(), (Enum[])this.enumClass.getEnumConstants()));
    }

    @Override
    public Object getParameter(AIHelper helper, String[] arguments) {
        return Enum.valueOf(this.enumClass, arguments[0].toUpperCase());
    }

    private static final class EnumArgumentDefinition
    extends ArgumentDefinition {
        private final Enum<?>[] options;

        public EnumArgumentDefinition(String descriptionType, String descriptionInfo, Enum<?>[] options) {
            super(descriptionType, descriptionInfo);
            this.options = options;
        }

        @Override
        public boolean couldEvaluateAgainst(String string) {
            for (Enum<?> type : this.options) {
                if (!type.name().equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void getTabCompleteOptions(String currentStart, Collection<String> addTo) {
            for (Enum<?> type : this.options) {
                if (!type.name().toLowerCase().startsWith(currentStart.toLowerCase())) continue;
                addTo.add(type.name().toLowerCase());
            }
        }
    }
}

