/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.util.ArrayList;
import java.util.Collection;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.CommandDefinition;
import net.famzangl.minecraft.minebot.ai.command.ParameterBuilder;

public class CommandNameBuilder
extends ParameterBuilder {
    public CommandNameBuilder(AICommandParameter annot) {
        super(annot);
    }

    @Override
    public void addArguments(ArrayList<ArgumentDefinition> list) {
        list.add(new CommandArgumentDefinition(this.annot.description()));
    }

    @Override
    public Object getParameter(AIHelper helper, String[] arguments) {
        return arguments[0];
    }

    private static final class CommandArgumentDefinition
    extends ArgumentDefinition {
        public CommandArgumentDefinition(String description) {
            super("Command", description);
        }

        @Override
        public boolean couldEvaluateAgainst(String string) {
            for (CommandDefinition command : AIChatController.getRegistry().getAllCommands()) {
                ArrayList<ArgumentDefinition> args = command.getArguments();
                if (!args.get(0).couldEvaluateAgainst(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void getTabCompleteOptions(String currentStart, Collection<String> addTo) {
            for (CommandDefinition command : AIChatController.getRegistry().getAllCommands()) {
                ArrayList<ArgumentDefinition> args = command.getArguments();
                args.get(0).getTabCompleteOptions(currentStart, addTo);
            }
        }
    }
}

