/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.util.ArrayList;
import java.util.Collection;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.ColoredBlockItemFilter;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.CommandEvaluationException;
import net.famzangl.minecraft.minebot.ai.command.ParameterBuilder;

public class ColorNameBuilder
extends ParameterBuilder {
    public ColorNameBuilder(AICommandParameter annot) {
        super(annot);
    }

    @Override
    public void addArguments(ArrayList<ArgumentDefinition> list) {
        list.add(new ColorArgumentDefinition(this.annot.description()));
    }

    @Override
    public Object getParameter(AIHelper helper, String[] arguments) {
        String[] colors = ColoredBlockItemFilter.COLORS;
        for (int i = 0; i < colors.length; ++i) {
            String color = colors[i];
            if (!color.equalsIgnoreCase(arguments[0])) continue;
            return i;
        }
        throw new CommandEvaluationException("Not a color: " + arguments[0]);
    }

    private static final class ColorArgumentDefinition
    extends ArgumentDefinition {
        public ColorArgumentDefinition(String description) {
            super("Color", description);
        }

        @Override
        public boolean couldEvaluateAgainst(String string) {
            for (String color : ColoredBlockItemFilter.COLORS) {
                if (!color.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void getTabCompleteOptions(String currentStart, Collection<String> addTo) {
            for (String color : ColoredBlockItemFilter.COLORS) {
                if (!color.toLowerCase().startsWith(currentStart.toLowerCase())) continue;
                addTo.add(color);
            }
        }
    }
}

