/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.command.AICommandParameter;
import net.famzangl.minecraft.minebot.ai.command.ArgumentDefinition;
import net.famzangl.minecraft.minebot.ai.command.CommandEvaluationException;
import net.famzangl.minecraft.minebot.ai.command.ParameterBuilder;
import net.minecraft.block.Block;

public class BlockNameBuilder
extends ParameterBuilder {
    private static final String MINECRAFT_PREFIX = "minecraft:";

    public BlockNameBuilder(AICommandParameter annot) {
        super(annot);
    }

    @Override
    public void addArguments(ArrayList<ArgumentDefinition> list) {
        list.add(new BlockArgumentDefinition(this.annot.description()));
    }

    @Override
    public Object getParameter(AIHelper helper, String[] arguments) {
        Object block = Block.field_149771_c.func_82594_a(arguments[0]);
        if (block == null) {
            throw new CommandEvaluationException("Block " + arguments[0] + " is unknown");
        }
        return block;
    }

    private static final class BlockArgumentDefinition
    extends ArgumentDefinition {
        public BlockArgumentDefinition(String description) {
            super("Block", description);
        }

        @Override
        public boolean couldEvaluateAgainst(String string) {
            return Block.field_149771_c.func_82594_a(string) != null;
        }

        @Override
        public void getTabCompleteOptions(String currentStart, Collection<String> addTo) {
            super.getTabCompleteOptions(currentStart, addTo);
            Set keys = Block.field_149771_c.func_148742_b();
            for (String k : keys) {
                if (k.startsWith(BlockNameBuilder.MINECRAFT_PREFIX)) {
                    String subKey = k.substring(BlockNameBuilder.MINECRAFT_PREFIX.length());
                    this.addKey(currentStart, addTo, subKey);
                    continue;
                }
                this.addKey(currentStart, addTo, k);
            }
        }

        private void addKey(String currentStart, Collection<String> addTo, String subKey) {
            if (subKey.startsWith(currentStart)) {
                addTo.add(subKey);
            }
        }
    }
}

