/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.PathFinderFieldData;

public class PathFinderField
implements Comparator<Integer> {
    private static final long MAX_RUN_TIME = 200L;
    private static final int Y_LEVEL = 32;
    private static int SIZE_X_Z = 256;
    private static int FIELD_SIZE = 0x200000;
    private final PathFinderFieldData data = new PathFinderFieldData();
    private Dest currentDest = null;
    private final PriorityQueue<Integer> pq = new PriorityQueue<Integer>(100, this);
    private static int FIELD_VISITED_MASK = 0x10000000;
    private static int FIELD_IN_QUEUE_MASK = 0x20000000;
    private static int FIELD_DISTANCE_SET_MASK = 0x40000000;
    private static int FIELD_DISTANCE_MASK = 65535;
    private static int FIELD_DISTANCE_SHIFT = 0;
    private static int FIELD_MOVEFROM_X_MASK = 983040;
    private static int FIELD_MOVEFROM_X_SHIFT = 16;
    private static int FIELD_MOVEFROM_Y_MASK = 0xF00000;
    private static int FIELD_MOVEFROM_Y_SHIFT = 20;
    private static int FIELD_MOVEFROM_Z_MASK = 0xF000000;
    private static int FIELD_MOVEFROM_Z_SHIFT = 24;
    private boolean isRunning = false;
    private int[] field;
    private long startTime;

    protected int getIndexForBlock(int x, int y, int z) {
        return x - this.data.offsetX & SIZE_X_Z - 1 | (z - this.data.offsetZ & SIZE_X_Z - 1) << 8 | (y - this.data.offsetY & 0x1F) << 16;
    }

    protected final int getX(int blockIndex) {
        return (blockIndex & SIZE_X_Z - 1) + this.data.offsetX;
    }

    protected final int getY(int currentNode) {
        return (currentNode >> 16 & 0x1F) + this.data.offsetY;
    }

    protected final int getZ(int currentNode) {
        return (currentNode >> 8 & SIZE_X_Z - 1) + this.data.offsetZ;
    }

    private boolean isVisited(int blockIndex) {
        return (this.field[blockIndex] & FIELD_VISITED_MASK) == FIELD_VISITED_MASK;
    }

    private void setVisited(int blockIndex) {
        int n = blockIndex;
        this.field[n] = this.field[n] | FIELD_VISITED_MASK;
    }

    private boolean isInQueue(int blockIndex) {
        return (this.field[blockIndex] & FIELD_IN_QUEUE_MASK) != 0;
    }

    private void setInQueue(int blockIndex) {
        int n = blockIndex;
        this.field[n] = this.field[n] | FIELD_IN_QUEUE_MASK;
    }

    private int getDistance(int blockIndex) {
        return (this.field[blockIndex] & FIELD_DISTANCE_SET_MASK) == 0 ? Integer.MAX_VALUE : (this.field[blockIndex] & FIELD_DISTANCE_MASK) >> FIELD_DISTANCE_SHIFT;
    }

    private void setDistance(int blockIndex, int distance) {
        int n = blockIndex;
        this.field[n] = this.field[n] & ~FIELD_DISTANCE_MASK;
        int n2 = blockIndex;
        this.field[n2] = this.field[n2] | distance << FIELD_DISTANCE_SHIFT & FIELD_DISTANCE_MASK;
        int n3 = blockIndex;
        this.field[n3] = this.field[n3] | FIELD_DISTANCE_SET_MASK;
    }

    private void setMoveFrom(int newIndex, int currentNode) {
        int newx = this.getX(newIndex);
        int newy = this.getY(newIndex);
        int newz = this.getZ(newIndex);
        int oldx = this.getX(currentNode);
        int oldy = this.getY(currentNode);
        int oldz = this.getZ(currentNode);
        int n = newIndex;
        this.field[n] = this.field[n] & ~(FIELD_MOVEFROM_X_MASK | FIELD_MOVEFROM_Y_MASK | FIELD_MOVEFROM_Z_MASK);
        int n2 = newIndex;
        this.field[n2] = this.field[n2] | newx - oldx << FIELD_MOVEFROM_X_SHIFT & FIELD_MOVEFROM_X_MASK;
        int n3 = newIndex;
        this.field[n3] = this.field[n3] | newy - oldy << FIELD_MOVEFROM_Y_SHIFT & FIELD_MOVEFROM_Y_MASK;
        int n4 = newIndex;
        this.field[n4] = this.field[n4] | newz - oldz << FIELD_MOVEFROM_Z_SHIFT & FIELD_MOVEFROM_Z_MASK;
    }

    private int getFromDirectionMasked(int blockIndex, int mask, int shift) {
        int res = (this.field[blockIndex] & mask) >> shift;
        int signBit = (mask >> shift) + 1 >> 1;
        if ((res & signBit) != 0) {
            res |= ~(mask >> shift);
        }
        return res;
    }

    private int getFromDirectionX(int blockIndex) {
        return this.getFromDirectionMasked(blockIndex, FIELD_MOVEFROM_X_MASK, FIELD_MOVEFROM_X_SHIFT);
    }

    private int getFromDirectionY(int blockIndex) {
        return this.getFromDirectionMasked(blockIndex, FIELD_MOVEFROM_Y_MASK, FIELD_MOVEFROM_Y_SHIFT);
    }

    private int getFromDirectionZ(int blockIndex) {
        return this.getFromDirectionMasked(blockIndex, FIELD_MOVEFROM_Z_MASK, FIELD_MOVEFROM_Z_SHIFT);
    }

    @Override
    public int compare(Integer o1, Integer o2) {
        return this.getDistance(o1) - this.getDistance(o2);
    }

    protected boolean searchSomethingAround(int cx, int cy, int cz) {
        if (this.data.offsetX != cx - SIZE_X_Z / 2 || this.data.offsetY != cy - 16 || this.data.offsetZ != cz - SIZE_X_Z / 2) {
            this.isRunning = false;
        }
        if (!this.isRunning) {
            System.out.println("Restart");
            this.field = new int[FIELD_SIZE];
            this.data.offsetX = cx - SIZE_X_Z / 2;
            this.data.offsetY = cy - 16;
            this.data.offsetZ = cz - SIZE_X_Z / 2;
            this.pq.clear();
            int start = this.getIndexForBlock(cx, cy, cz);
            this.pq.add(start);
            float startRating = this.rateDestination(start);
            this.setDistance(start, 1);
            this.currentDest = startRating >= 0.0f ? new Dest(start, startRating) : null;
            this.isRunning = true;
        }
        this.startTime = System.currentTimeMillis();
        long iteration = 0L;
        while (!this.pq.isEmpty() && ((iteration++ & 0xFFL) != 0L || this.hasTimeLeft(this.startTime))) {
            int[] neighbours;
            int currentNode = this.pq.poll();
            int currentDistance = this.getDistance(currentNode);
            Dest head = this.currentDest;
            if (head != null && (float)(currentDistance + 1) > head.destDistanceRating) {
                this.planPathTo(head.destNode, cx, cy, cz);
                this.terminated();
                return true;
            }
            float rating = this.rateDestination(currentNode);
            if (rating >= 0.0f) {
                Dest newDest = new Dest(currentNode, rating);
                if (this.currentDest == null || newDest.compareTo(this.currentDest) < 0) {
                    this.currentDest = newDest;
                }
            }
            for (int n : neighbours = this.getNeighbours(currentNode)) {
                if (n < 0 || this.isVisited(n)) continue;
                int distance = this.distanceFor(currentNode, n) + currentDistance;
                if (distance < this.getDistance(n)) {
                    this.setDistance(n, distance);
                    this.setMoveFrom(n, currentNode);
                }
                if (this.isInQueue(n)) continue;
                this.setInQueue(n);
                this.pq.add(n);
            }
            this.setVisited(currentNode);
        }
        if (this.pq.isEmpty()) {
            this.noPathFound();
            this.terminated();
            return true;
        }
        System.out.println("Warning: Path finding needs more time. Just got " + iteration + " iterations.");
        return false;
    }

    private boolean hasTimeLeft(long startTime) {
        return startTime + 200L > System.currentTimeMillis();
    }

    private void terminated() {
        this.isRunning = false;
        this.field = null;
        this.pq.clear();
        this.currentDest = null;
    }

    protected int distanceFor(int from, int to) {
        return 1;
    }

    protected void noPathFound() {
        System.out.println("Could not find a path.");
    }

    private void planPathTo(int currentNode, int origX, int origY, int origZ) {
        int current;
        int cx = this.getX(currentNode);
        int cy = this.getY(currentNode);
        System.out.println("Reconstruct.");
        LinkedList<Pos> path = new LinkedList<Pos>();
        for (int cz = this.getZ(currentNode); cx != origX || cy != origY || cz != origZ; cx -= this.getFromDirectionX(current), cy -= this.getFromDirectionY(current), cz -= this.getFromDirectionZ(current)) {
            path.addFirst(new Pos(cx, cy, cz));
            current = this.getIndexForBlock(cx, cy, cz);
            this.debug(current);
        }
        path.addFirst(new Pos(origX, origY, origZ));
        this.foundPath(path);
    }

    protected void foundPath(LinkedList<Pos> path) {
        System.out.println("Found a path!");
        for (Pos p : path) {
            System.out.println("Path part: " + p);
        }
    }

    private float rateDestination(int currentNode) {
        int cx = this.getX(currentNode);
        int cy = this.getY(currentNode);
        int cz = this.getZ(currentNode);
        int distance = this.getDistance(currentNode);
        return this.rateDestination(distance, cx, cy, cz);
    }

    protected float rateDestination(int distance, int x, int y, int z) {
        return distance;
    }

    protected int[] getNeighbours(int currentNode) {
        int[] res = new int[10];
        int cx = this.getX(currentNode);
        int cz = this.getZ(currentNode);
        int cy = this.getY(currentNode);
        res[0] = this.getNeighbour(currentNode, cx, cy + 1, cz);
        res[1] = this.getNeighbour(currentNode, cx, cy - 1, cz);
        res[2] = this.getNeighbour(currentNode, cx + 1, cy, cz);
        res[3] = this.getNeighbour(currentNode, cx - 1, cy, cz);
        res[4] = this.getNeighbour(currentNode, cx, cy, cz + 1);
        res[5] = this.getNeighbour(currentNode, cx, cy, cz - 1);
        res[6] = this.getNeighbour(currentNode, cx + 1, cy - 1, cz);
        res[7] = this.getNeighbour(currentNode, cx - 1, cy - 1, cz);
        res[8] = this.getNeighbour(currentNode, cx, cy - 1, cz + 1);
        res[9] = this.getNeighbour(currentNode, cx, cy - 1, cz - 1);
        return res;
    }

    protected int getNeighbour(int currentNode, int cx, int cy, int cz) {
        return cy > 1 && cy < 256 && cx > this.data.offsetX && cx < this.data.offsetX + 256 && cy > this.data.offsetY && cy < this.data.offsetY + 32 && cz > this.data.offsetZ && cz < this.data.offsetZ + 256 ? this.getIndexForBlock(cx, cy, cz) : -1;
    }

    private void debug(int nodeId) {
        System.out.println("pos=" + new Pos(this.getX(nodeId), this.getY(nodeId), this.getZ(nodeId)) + ", inQueue=" + this.isInQueue(nodeId) + ", visited=" + this.isVisited(nodeId) + ", distance=" + this.getDistance(nodeId) + ", fromX=" + this.getFromDirectionX(nodeId) + ", fromY=" + this.getFromDirectionY(nodeId) + ", fromZ=" + this.getFromDirectionZ(nodeId) + ", data=" + Integer.toHexString(this.field[nodeId]));
    }

    private static class Dest
    implements Comparable<Dest> {
        int destNode;
        float destDistanceRating;

        public Dest(int destNode, float rating) {
            this.destNode = destNode;
            this.destDistanceRating = rating;
        }

        @Override
        public int compareTo(Dest o) {
            return Float.compare(this.destDistanceRating, o.destDistanceRating);
        }
    }
}

