/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai;

import java.util.List;
import java.util.Random;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.BlockWhitelist;
import net.famzangl.minecraft.minebot.ai.InteractAlways;
import net.famzangl.minecraft.minebot.ai.ItemFilter;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.task.BlockSide;
import net.famzangl.minecraft.minebot.build.BuildManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockWall;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class AIHelper {
    private static final int BEDROCK_ID = Block.func_149682_b((Block)Blocks.field_150357_h);
    private static final double SNEAK_OFFSET = 0.2;
    private static final double WALK_PER_STEP = 0.215;
    private static final double MIN_DISTANCE_ERROR = 0.05;
    private static Minecraft mc = Minecraft.func_71410_x();
    private final Random rand = new Random();
    public static final BlockWhitelist normalBlocks = new BlockWhitelist(new Block[]{Blocks.field_150357_h, Blocks.field_150342_X, Blocks.field_150336_V, Blocks.field_150420_aW, Blocks.field_150414_aQ, Blocks.field_150435_aG, Blocks.field_150402_ci, Blocks.field_150365_q, Blocks.field_150347_e, Blocks.field_150462_ai, Blocks.field_150484_ah, Blocks.field_150482_ag, Blocks.field_150346_d, Blocks.field_150334_T, Blocks.field_150373_bw, Blocks.field_150475_bE, Blocks.field_150412_bA, Blocks.field_150458_ak, Blocks.field_150460_al, Blocks.field_150359_w, Blocks.field_150426_aN, Blocks.field_150349_c, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_150405_ch, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150362_t, Blocks.field_150361_u, Blocks.field_150428_aP, Blocks.field_150470_am, Blocks.field_150374_bv, Blocks.field_150439_ay, Blocks.field_150364_r, Blocks.field_150363_s, Blocks.field_150440_ba, Blocks.field_150341_Y, Blocks.field_150391_bh, Blocks.field_150385_bj, Blocks.field_150386_bk, Blocks.field_150424_aL, Blocks.field_150343_Z, Blocks.field_150403_cj, Blocks.field_150344_f, Blocks.field_150423_aK, Blocks.field_150371_ca, Blocks.field_150449_bY, Blocks.field_150419_aX, Blocks.field_150451_bX, Blocks.field_150379_bu, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_150399_cn, Blocks.field_150406_ce, Blocks.field_150348_b, Blocks.field_150417_aV, Blocks.field_150325_L});
    public static final BlockWhitelist fallingBlocks = new BlockWhitelist(Blocks.field_150351_n, Blocks.field_150354_m);
    public static final BlockWhitelist air = new BlockWhitelist(Blocks.field_150350_a);
    public static final BlockWhitelist stairBlocks = new BlockWhitelist(new Block[]{Blocks.field_150400_ck, Blocks.field_150487_bG, Blocks.field_150389_bf, Blocks.field_150401_cl, Blocks.field_150481_bH, Blocks.field_150387_bl, Blocks.field_150476_ad, Blocks.field_150372_bz, Blocks.field_150485_bF, Blocks.field_150390_bg, Blocks.field_150446_ar, Blocks.field_150333_U, Blocks.field_150376_bx, Blocks.field_150370_cb});
    private static final BlockWhitelist explicitFootWalkableBlocks = new BlockWhitelist(new Block[]{Blocks.field_150329_H, Blocks.field_150327_N, Blocks.field_150328_O, Blocks.field_150464_aj, Blocks.field_150459_bM, Blocks.field_150469_bN, Blocks.field_150393_bb, Blocks.field_150394_bc, Blocks.field_150478_aa, Blocks.field_150404_cg, Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150448_aq, Blocks.field_150408_cc, Blocks.field_150398_cm, Blocks.field_150337_Q, Blocks.field_150338_P, Blocks.field_150488_af, Blocks.field_150345_g, Blocks.field_150431_aC, Blocks.field_150388_bm, Blocks.field_150472_an, Blocks.field_150444_as});
    public static final BlockWhitelist headWalkableBlocks = new BlockWhitelist(new Block[]{Blocks.field_150350_a, Blocks.field_150478_aa, Blocks.field_150398_cm, Blocks.field_150429_aA, Blocks.field_150375_by});
    public static final BlockWhitelist walkableBlocks = explicitFootWalkableBlocks.unionWith(headWalkableBlocks);
    public static final BlockWhitelist explicitSafeSideBlocks = new BlockWhitelist(Blocks.field_150467_bQ, Blocks.field_150422_aJ, Blocks.field_150396_be, Blocks.field_150463_bK, Blocks.field_150434_aF, Blocks.field_150436_aH, Blocks.field_150321_G, Blocks.field_150410_aZ, Blocks.field_150324_C, Blocks.field_150381_bn, Blocks.field_150392_bi, Blocks.field_150382_bo, Blocks.field_150395_bd);
    public static final BlockWhitelist safeStandableBlocks = normalBlocks.unionWith(fallingBlocks).unionWith(stairBlocks);
    public static final BlockWhitelist safeSideBlocks = explicitSafeSideBlocks.unionWith(safeStandableBlocks).unionWith(walkableBlocks).unionWith(air);
    public static final BlockWhitelist safeHeadBlocks = stairBlocks.unionWith(walkableBlocks).unionWith(normalBlocks).unionWith(air);
    public static final BlockWhitelist safeDestructableBlocks = new BlockWhitelist(Blocks.field_150395_bd);
    public final BuildManager buildManager = new BuildManager();
    private boolean objectMouseOverInvalidated;
    protected Pos pos1 = null;
    protected Pos pos2 = null;
    private MovementInput resetMovementInput;
    private KeyBinding resetAttackKey;
    private KeyBinding resetUseItemKey;
    private boolean useItemKeyJustPressed;
    private boolean attackKeyJustPressed;
    protected boolean doUngrab;
    private KeyBinding resetSneakKey;
    private boolean sneakKeyJustPressed;

    public Minecraft getMinecraft() {
        return mc;
    }

    public Block getBlock(int x, int y, int z) {
        return AIHelper.mc.field_71441_e.func_147439_a(x, y, z);
    }

    public Block getBlock(Pos pos) {
        return this.getBlock(pos.x, pos.y, pos.z);
    }

    public Pos getPos1() {
        return this.pos1;
    }

    public Pos getPos2() {
        return this.pos2;
    }

    public void setPosition(Pos pos, boolean isPos2) {
        int posIndex;
        if (isPos2) {
            this.pos2 = pos;
            posIndex = 2;
        } else {
            this.pos1 = pos;
            posIndex = 1;
        }
        AIChatController.addChatLine("Set position" + posIndex + " to " + pos);
    }

    public void face(double x, double y, double z) {
        double d0 = x - AIHelper.mc.field_71439_g.field_70165_t;
        double d2 = y - AIHelper.mc.field_71439_g.field_70163_u;
        double d1 = z - AIHelper.mc.field_71439_g.field_70161_v;
        double d3 = d0 * d0 + d2 * d2 + d1 * d1;
        if (d3 >= 2.500000277905201E-7) {
            float rotationYaw = AIHelper.mc.field_71439_g.field_70177_z;
            float rotationPitch = AIHelper.mc.field_71439_g.field_70125_A;
            float yaw = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
            float pitch = (float)(-(Math.atan2(d2, Math.sqrt(d0 * d0 + d1 * d1)) * 180.0 / Math.PI));
            AIHelper.mc.field_71439_g.func_70082_c((yaw - rotationYaw) / 0.15f, -(pitch - rotationPitch) / 0.15f);
            this.invalidateObjectMouseOver();
        }
    }

    public boolean canSelectItem(ItemFilter f) {
        for (int i = 0; i < 9; ++i) {
            if (!f.matches(AIHelper.mc.field_71439_g.field_71071_by.func_70301_a(i))) continue;
            return true;
        }
        return false;
    }

    public boolean selectCurrentItem(ItemFilter f) {
        if (f.matches(AIHelper.mc.field_71439_g.field_71071_by.func_70448_g())) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            if (!f.matches(AIHelper.mc.field_71439_g.field_71071_by.func_70301_a(i))) continue;
            AIHelper.mc.field_71439_g.field_71071_by.field_70461_c = i;
            return true;
        }
        return false;
    }

    public Pos findBlock(Block blockType) {
        Pos current = this.getPlayerPosition();
        Pos pos = null;
        for (int x = current.x - 2; x <= current.x + 2; ++x) {
            for (int z = current.z - 2; z <= current.z + 2; ++z) {
                for (int y = current.y - 1; y <= current.y + 2; ++y) {
                    Block block = AIHelper.mc.field_71441_e.func_147439_a(x, y, z);
                    if (!Block.func_149680_a((Block)block, (Block)blockType)) continue;
                    pos = new Pos(x, y, z);
                }
            }
        }
        return pos;
    }

    public boolean isFacingBlock(int x, int y, int z) {
        MovingObjectPosition o = this.getObjectMouseOver();
        return o != null && o.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && o.field_72311_b == x && o.field_72312_c == y && o.field_72309_d == z;
    }

    public boolean isFacingBlock(int x, int y, int z, ForgeDirection blockSide, BlockSide half) {
        if (!this.isFacingBlock(x, y, z, AIHelper.sideToDir(blockSide))) {
            return false;
        }
        double fy = this.getObjectMouseOver().field_72307_f.field_72448_b - (double)y;
        return half != BlockSide.LOWER_HALF && fy > 0.5 || half != BlockSide.UPPER_HALF && fy <= 0.5;
    }

    public boolean isFacingBlock(int x, int y, int z, ForgeDirection blockSide) {
        return this.isFacingBlock(x, y, z, AIHelper.sideToDir(blockSide));
    }

    public boolean isFacingBlock(int x, int y, int z, int side) {
        MovingObjectPosition o = this.getObjectMouseOver();
        return o != null && o.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && o.field_72311_b == x && o.field_72312_c == y && o.field_72309_d == z && o.field_72310_e == side;
    }

    public void invalidateObjectMouseOver() {
        this.objectMouseOverInvalidated = true;
    }

    public MovingObjectPosition getObjectMouseOver() {
        if (this.objectMouseOverInvalidated) {
            this.objectMouseOverInvalidated = false;
            AIHelper.mc.field_71460_t.func_78473_a(1.0f);
        }
        return AIHelper.mc.field_71476_x;
    }

    public boolean isStandingOn(int x, int y, int z) {
        return Math.abs((double)x + 0.5 - AIHelper.mc.field_71439_g.field_70165_t) < 0.2 && Math.abs((double)z + 0.5 - AIHelper.mc.field_71439_g.field_70161_v) < 0.2 && Math.abs(AIHelper.mc.field_71439_g.field_70121_D.field_72338_b - (double)y) < 0.52;
    }

    public Pos getPlayerPosition() {
        int x = (int)Math.floor(this.getMinecraft().field_71439_g.field_70165_t);
        int y = (int)Math.floor(this.getMinecraft().field_71439_g.field_70121_D.field_72338_b + 0.05);
        int z = (int)Math.floor(this.getMinecraft().field_71439_g.field_70161_v);
        return new Pos(x, y, z);
    }

    public void selectToolFor(final int x, final int y, final int z) {
        this.selectCurrentItem(new ItemFilter(){

            @Override
            public boolean matches(ItemStack itemStack) {
                return itemStack != null && itemStack.func_77973_b() != null && itemStack.func_77973_b().func_150893_a(itemStack, AIHelper.this.getBlock(x, y, z)) > 1.0f;
            }
        });
    }

    public boolean isAirBlock(int x, int y, int z) {
        int block = this.getBlockId(x, y, z);
        return air.contains(block);
    }

    public boolean isSafeGroundBlock(int x, int y, int z) {
        int block = this.getBlockId(x, y, z);
        return safeStandableBlocks.contains(block);
    }

    public boolean isSafeHeadBlock(int x, int y, int z) {
        int block = this.getBlockId(x, y, z);
        return safeHeadBlocks.contains(block);
    }

    public boolean isFallingBlock(int x, int y, int z) {
        int block = this.getBlockId(x, y, z);
        return fallingBlocks.contains(block);
    }

    public final boolean hasSafeSides(int cx, int cy, int cz) {
        return this.isSafeSideBlock(cx - 1, cy, cz) && this.isSafeSideBlock(cx + 1, cy, cz) && this.isSafeSideBlock(cx, cy, cz + 1) && this.isSafeSideBlock(cx, cy, cz - 1);
    }

    public final boolean isSafeSideBlock(int x, int y, int z) {
        int block = this.getBlockId(x, y, z);
        return safeSideBlocks.contains(block);
    }

    public boolean canWalkThrough(Block block) {
        return headWalkableBlocks.contains(block);
    }

    public boolean canWalkOn(Block block) {
        return walkableBlocks.contains(block);
    }

    @Deprecated
    public boolean isRailBlock(Block block) {
        return AIHelper.blockIsOneOf(block, Blocks.field_150318_D, Blocks.field_150319_E, Blocks.field_150448_aq, Blocks.field_150408_cc);
    }

    public boolean isSafeStandableBlock(Block block) {
        return safeStandableBlocks.contains(block);
    }

    public boolean isSideTorch(int x, int y, int z) {
        return AIHelper.blockIsOneOf(this.getBlock(x, y, z), Blocks.field_150478_aa, Blocks.field_150429_aA) && this.getMinecraft().field_71441_e.func_72805_g(x, y, z) != 5;
    }

    public void faceAndDestroy(int x, int y, int z) {
        if (!this.isFacingBlock(x, y, z)) {
            this.faceBlock(x, y, z);
        }
        if (this.isFacingBlock(x, y, z)) {
            this.selectToolFor(x, y, z);
            this.overrideAttack();
        }
    }

    public void faceAndDestroyWithHangingBlock(int x, int y, int z) {
        this.faceAndDestroy(x, y, z);
        if (!this.isFacingBlock(x, y, z)) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                Pos hanging;
                if (!this.isFacingBlock(x + d.offsetX, y + d.offsetY, z + d.offsetZ) || (hanging = this.getHaningOnBlock(x + d.offsetX, y + d.offsetY, z + d.offsetZ)) == null || hanging.x != x || hanging.y != y || hanging.z != z) continue;
                this.overrideAttack();
            }
        }
    }

    public Pos getHaningOnBlock(int x, int y, int z) {
        Block b = this.getBlock(x, y, z);
        int meta = AIHelper.mc.field_71441_e.func_72805_g(x, y, z);
        if (AIHelper.blockIsOneOf(b, Blocks.field_150478_aa, Blocks.field_150429_aA)) {
            ForgeDirection dir = this.getTorchDirection(meta);
            return new Pos(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
        }
        if (AIHelper.blockIsOneOf(b, Blocks.field_150468_ap, Blocks.field_150444_as)) {
            ForgeDirection dir = this.getSignDirection(meta);
            return new Pos(x - dir.offsetX, y - dir.offsetY, z - dir.offsetZ);
        }
        if (walkableBlocks.contains(b)) {
            return new Pos(x, y - 1, z);
        }
        return null;
    }

    private ForgeDirection getSignDirection(int metaValue) {
        return (new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST})[metaValue];
    }

    public ForgeDirection getTorchDirection(int metaValue) {
        return (new ForgeDirection[]{ForgeDirection.UNKNOWN, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH, ForgeDirection.UP})[metaValue];
    }

    public void faceBlock(int x, int y, int z) {
        this.face((double)x + this.randBetween(0.1, 0.9), (double)y + this.randBetween(0.1, 0.9), (double)z + this.randBetween(0.1, 0.9));
    }

    public void faceSideOf(int x, int y, int z, ForgeDirection sideToFace) {
        double faceX = (double)x + this.randBetween(0.1, 0.9);
        double faceY = (double)y + this.randBetween(0.1, 0.9);
        double faceZ = (double)z + this.randBetween(0.1, 0.9);
        Block block = this.getBoundsBlock(x, y, z);
        switch (sideToFace) {
            case UP: {
                faceY = (double)y + block.func_149669_A();
                break;
            }
            case DOWN: {
                faceY = (double)y + block.func_149665_z();
                break;
            }
            case EAST: {
                faceX = (double)x + block.func_149753_y();
                break;
            }
            case WEST: {
                faceX = (double)x + block.func_149704_x();
                break;
            }
            case SOUTH: {
                faceZ = (double)z + block.func_149693_C();
                break;
            }
            case NORTH: {
                faceZ = (double)z + block.func_149706_B();
                break;
            }
        }
        this.face(faceX, faceY, faceZ);
    }

    public void faceSideOf(int x, int y, int z, ForgeDirection sideToFace, double minY, double maxY, double centerX, double centerZ, ForgeDirection xzdir) {
        double faceZ;
        double faceX;
        Block block = this.getBoundsBlock(x, y, z);
        minY = Math.max(minY, block.func_149665_z());
        maxY = Math.min(maxY, block.func_149669_A());
        double faceY = this.randBetweenNice(minY, maxY);
        if (xzdir == ForgeDirection.EAST) {
            faceX = this.randBetween(Math.max(block.func_149704_x(), centerX), block.func_149753_y());
            faceZ = centerZ;
        } else if (xzdir == ForgeDirection.WEST) {
            faceX = this.randBetween(block.func_149704_x(), Math.min(block.func_149753_y(), centerX));
            faceZ = centerZ;
        } else if (xzdir == ForgeDirection.SOUTH) {
            faceZ = this.randBetween(Math.max(block.func_149706_B(), centerZ), block.func_149693_C());
            faceX = centerX;
        } else if (xzdir == ForgeDirection.NORTH) {
            faceZ = this.randBetween(block.func_149706_B(), Math.min(block.func_149693_C(), centerZ));
            faceX = centerX;
        } else {
            faceX = this.randBetweenNice(block.func_149704_x(), block.func_149753_y());
            faceZ = this.randBetweenNice(block.func_149706_B(), block.func_149693_C());
        }
        switch (sideToFace) {
            case UP: {
                faceY = block.func_149669_A();
                break;
            }
            case DOWN: {
                faceY = block.func_149665_z();
                break;
            }
            case EAST: {
                faceX = block.func_149753_y();
                break;
            }
            case WEST: {
                faceX = block.func_149704_x();
                break;
            }
            case SOUTH: {
                faceZ = block.func_149693_C();
                break;
            }
            case NORTH: {
                faceZ = block.func_149706_B();
                break;
            }
        }
        this.face(faceX + (double)x, faceY + (double)y, faceZ + (double)z);
    }

    private double randBetweenNice(double minY, double maxY) {
        return maxY - minY < 0.1 ? (maxY + minY) / 2.0 : this.randBetween(minY + 0.03, maxY - 0.03);
    }

    private double randBetween(double a, double b) {
        return this.rand.nextDouble() * (b - a) + a;
    }

    public void overrideMovement(MovementInput i) {
        if (this.resetMovementInput == null) {
            this.resetMovementInput = AIHelper.mc.field_71439_g.field_71158_b;
        }
        AIHelper.mc.field_71439_g.field_71158_b = i;
    }

    public void overrideUseItem() {
        if (this.resetUseItemKey == null) {
            this.resetUseItemKey = AIHelper.mc.field_71474_y.field_74313_G;
        }
        AIHelper.mc.field_71474_y.field_74313_G = new InteractAlways(AIHelper.mc.field_71474_y.field_74312_F.func_151464_g(), 501, AIHelper.mc.field_71474_y.field_74312_F.func_151466_e(), !this.useItemKeyJustPressed);
    }

    public void overrideAttack() {
        if (AIHelper.mc.field_71439_g.func_71039_bw()) {
            System.err.println("WARNING: Player is currently using an item, but attack was requested.");
        }
        if (this.resetAttackKey == null) {
            this.resetAttackKey = AIHelper.mc.field_71474_y.field_74312_F;
        }
        AIHelper.mc.field_71474_y.field_74312_F = new InteractAlways(AIHelper.mc.field_71474_y.field_74312_F.func_151464_g(), 502, AIHelper.mc.field_71474_y.field_74312_F.func_151466_e(), !this.attackKeyJustPressed);
    }

    public void overrideSneak() {
        if (this.resetSneakKey == null) {
            this.resetSneakKey = AIHelper.mc.field_71474_y.field_74311_E;
        }
        AIHelper.mc.field_71474_y.field_74311_E = new InteractAlways(AIHelper.mc.field_71474_y.field_74311_E.func_151464_g(), 503, AIHelper.mc.field_71474_y.field_74311_E.func_151466_e(), !this.sneakKeyJustPressed);
    }

    protected void resetAllInputs() {
        if (this.resetMovementInput != null) {
            AIHelper.mc.field_71439_g.field_71158_b = this.resetMovementInput;
            this.resetMovementInput = null;
        }
        boolean bl = this.attackKeyJustPressed = this.resetAttackKey != null;
        if (this.resetAttackKey != null) {
            AIHelper.mc.field_71474_y.field_74312_F = this.resetAttackKey;
            this.resetAttackKey = null;
        }
        boolean bl2 = this.useItemKeyJustPressed = this.resetUseItemKey != null;
        if (this.resetUseItemKey != null) {
            AIHelper.mc.field_71474_y.field_74313_G = this.resetUseItemKey;
            this.resetUseItemKey = null;
        }
        boolean bl3 = this.sneakKeyJustPressed = this.resetSneakKey != null;
        if (this.resetSneakKey != null) {
            AIHelper.mc.field_71474_y.field_74311_E = this.resetSneakKey;
            this.resetSneakKey = null;
        }
    }

    protected boolean userTookOver() {
        MovementInput mi = this.resetMovementInput == null ? AIHelper.mc.field_71439_g.field_71158_b : this.resetMovementInput;
        KeyBinding attack = this.resetAttackKey == null ? AIHelper.mc.field_71474_y.field_74312_F : this.resetAttackKey;
        KeyBinding use = this.resetUseItemKey == null ? AIHelper.mc.field_71474_y.field_74313_G : this.resetUseItemKey;
        KeyBinding sneak = this.resetSneakKey == null ? AIHelper.mc.field_71474_y.field_74311_E : this.resetSneakKey;
        return mi.field_78900_b != 0.0f || mi.field_78902_a != 0.0f || mi.field_78901_c || attack.func_151470_d() || use.func_151470_d() || sneak.func_151470_d();
    }

    @Deprecated
    public static boolean blockIsOneOf(Block needle, Block ... haystack) {
        for (Block h : haystack) {
            if (!Block.func_149680_a((Block)needle, (Block)h)) continue;
            return true;
        }
        return false;
    }

    public int getBlockId(int x, int y, int z) {
        ExtendedBlockStorage extendedblockstorage;
        if (y < 0 || y >= 256) {
            return BEDROCK_ID;
        }
        Chunk chunk = AIHelper.mc.field_71441_e.func_72964_e(x >> 4, z >> 4);
        int blockId = 0;
        ExtendedBlockStorage[] sa = chunk.func_76587_i();
        if (y >> 4 < sa.length && (extendedblockstorage = sa[y >> 4]) != null) {
            int lx = x & 0xF;
            int ly = y & 0xF;
            int lz = z & 0xF;
            blockId = extendedblockstorage.func_76658_g()[ly << 8 | lz << 4 | lx] & 0xFF;
            NibbleArray blockMSBArray = extendedblockstorage.func_76660_i();
            if (blockMSBArray != null) {
                blockId |= blockMSBArray.func_76582_a(lx, ly, lz) << 8;
            }
        }
        return blockId;
    }

    public double realBlockTopY(int x, int y, int z) {
        int blockMetadata;
        Block block = this.getBlock(x, y - 1, z);
        double maxY = block instanceof BlockFence || block instanceof BlockFenceGate || block instanceof BlockWall ? 1.5 : (block instanceof BlockSlab ? (((blockMetadata = this.getMinecraft().field_71441_e.func_72805_g(x, y, z)) & 8) == 0 ? 0.5 : 1.0) : block.func_149669_A());
        return (double)(y - 1) + maxY;
    }

    public List<Entity> getEntities(int dist, IEntitySelector selector) {
        return AIHelper.mc.field_71441_e.func_94576_a((Entity)AIHelper.mc.field_71451_h, AIHelper.mc.field_71451_h.field_70121_D.func_72321_a((double)(-dist), (double)(-dist), (double)(-dist)).func_72321_a((double)dist, (double)dist, (double)dist).func_72314_b(1.0, 1.0, 1.0), selector);
    }

    public Entity getClosestEntity(int dist, IEntitySelector selector) {
        List<Entity> entities = this.getEntities(dist, selector);
        double mindist = Double.MAX_VALUE;
        Entity found = null;
        for (Entity e : entities) {
            double mydist = e.func_70068_e((Entity)AIHelper.mc.field_71439_g);
            if (!(mydist < mindist)) continue;
            found = e;
            mindist = mydist;
        }
        return found;
    }

    public void ungrab() {
        this.doUngrab = true;
    }

    public boolean sneakFrom(int blockX, int blockY, int blockZ, ForgeDirection inDirection) {
        Block block = this.getBoundsBlock(blockX, blockY, blockZ);
        double destX = (double)blockX + 0.5;
        double destZ = (double)blockZ + 0.5;
        switch (inDirection) {
            case EAST: {
                destX = (double)blockX + block.func_149753_y() + 0.2;
                break;
            }
            case WEST: {
                destX = (double)blockX + block.func_149704_x() - 0.2;
                break;
            }
            case SOUTH: {
                destZ = (double)blockZ + block.func_149693_C() + 0.2;
                break;
            }
            case NORTH: {
                destZ = (double)blockZ + block.func_149706_B() - 0.2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot handle " + inDirection);
            }
        }
        return this.walkTowards(destX, destZ, false);
    }

    private Block getBoundsBlock(int blockX, int blockY, int blockZ) {
        Block block = this.getBlock(blockX, blockY, blockZ);
        if (block instanceof BlockStairs) {
            block = Blocks.field_150346_d;
        }
        block.func_149719_a((IBlockAccess)AIHelper.mc.field_71441_e, blockX, blockY, blockZ);
        return block;
    }

    public boolean walkTowards(double x, double z, boolean jump) {
        return this.walkTowards(x, z, jump, true);
    }

    public boolean walkTowards(double x, double z, boolean jump, boolean face) {
        double dx = x - AIHelper.mc.field_71439_g.field_70165_t;
        double dz = z - AIHelper.mc.field_71439_g.field_70161_v;
        double distTo = Math.sqrt(dx * dx + dz * dz);
        if (distTo > 0.05) {
            if (face) {
                this.face(x, AIHelper.mc.field_71439_g.field_70163_u, z);
            }
            double speed = 1.0;
            if (distTo < 0.86) {
                speed = Math.max(distTo / 0.215 / 4.0, 0.1);
            }
            double yaw = (double)(AIHelper.mc.field_71439_g.field_70177_z / 180.0f) * Math.PI;
            double lookX = -Math.sin(yaw);
            double lookZ = Math.cos(yaw);
            double dlength = Math.sqrt(dx * dx + dz * dz);
            double same = (lookX * dx + lookZ * dz) / dlength;
            double strafe = (lookZ * dx - lookX * dz) / dlength;
            MovementInput movement = new MovementInput();
            movement.field_78900_b = (float)(speed * same);
            movement.field_78902_a = (float)(speed * strafe);
            movement.field_78901_c = jump;
            this.overrideMovement(movement);
            if (distTo < 0.5) {
                this.overrideSneak();
            }
            return false;
        }
        return true;
    }

    public static int sideToDir(ForgeDirection blockSide) {
        switch (blockSide) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case EAST: {
                return 5;
            }
            case WEST: {
                return 4;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Cannot handle: " + blockSide);
    }

    public boolean isJumping() {
        return !AIHelper.mc.field_71439_g.field_70122_E;
    }

    public ForgeDirection getLookDirection() {
        switch (MathHelper.func_76128_c((double)((double)(this.getMinecraft().field_71439_g.field_70177_z / 360.0f * 4.0f) + 0.5)) & 3) {
            case 1: {
                return ForgeDirection.WEST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.EAST;
            }
        }
        return ForgeDirection.SOUTH;
    }

    public boolean isAlive() {
        return AIHelper.mc.field_71439_g != null && AIHelper.mc.field_71439_g.func_110143_aJ() > 0.0f;
    }

    public void respawn() {
        if (!this.isAlive()) {
            AIHelper.mc.field_71439_g.func_71004_bE();
            mc.func_147108_a(null);
        }
    }

    public boolean hasItemInInvetory(ItemFilter itemFiler) {
        for (ItemStack s : AIHelper.mc.field_71439_g.field_71071_by.field_70462_a) {
            if (!itemFiler.matches(s)) continue;
            return true;
        }
        return false;
    }

    public static ForgeDirection getDirectionForXZ(int x, int z) {
        if (x != 0 || z != 0) {
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (d.offsetX != x || d.offsetZ != z) continue;
                return d;
            }
        }
        throw new IllegalArgumentException("Cannot convert to direction: " + x + " " + z);
    }

    public static ForgeDirection getDirectionFor(Pos pos) {
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            if (d.offsetX != pos.x || d.offsetY != pos.y || d.offsetZ != pos.z) continue;
            return d;
        }
        throw new IllegalArgumentException("Cannot convert to direction: " + pos);
    }

    public int getLightAt(Pos pos) {
        Chunk chunk = AIHelper.mc.field_71441_e.func_72964_e(pos.x >> 4, pos.z >> 4);
        ExtendedBlockStorage storage = chunk.func_76587_i()[pos.y >> 4];
        if (storage == null) {
            return 0;
        }
        return storage.func_76674_d(pos.x & 0xF, pos.y & 0xF, pos.z & 0xF);
    }
}

