/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot.ai;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Map;
import net.famzangl.minecraft.minebot.Pos;
import net.famzangl.minecraft.minebot.ai.AIHelper;
import net.famzangl.minecraft.minebot.ai.AIStrategyFactory;
import net.famzangl.minecraft.minebot.ai.command.AIChatController;
import net.famzangl.minecraft.minebot.ai.command.IAIControllable;
import net.famzangl.minecraft.minebot.ai.render.BuildMarkerRenderer;
import net.famzangl.minecraft.minebot.ai.render.MarkingStrategy;
import net.famzangl.minecraft.minebot.ai.render.PosMarkerRenderer;
import net.famzangl.minecraft.minebot.ai.strategy.AIStrategy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MouseHelper;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.lwjgl.input.Keyboard;

public class AIController
extends AIHelper
implements IAIControllable {
    private static final Hashtable<KeyBinding, AIStrategyFactory> uses = new Hashtable();
    protected static final KeyBinding stop = new KeyBinding("Stop", Keyboard.getKeyIndex((String)"N"), "Command Mod");
    protected static final KeyBinding ungrab = new KeyBinding("Ungrab", Keyboard.getKeyIndex((String)"U"), "Command Mod");
    private boolean dead;
    private AIStrategy currentStrategy;
    private String strategyDescr = "";
    private final Object strategyDescrMutex = new Object();
    private AIStrategy requestedStrategy;
    private boolean nextPosIsPos2;
    private PosMarkerRenderer markerRenderer;
    private boolean skipNextTick;
    private MouseHelper oldMouseHelper;
    private BuildMarkerRenderer buildMarkerRenderer;

    public AIController() {
        AIChatController.getRegistry().setControlled(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.START || this.getMinecraft().field_71439_g == null) {
            return;
        }
        if (this.skipNextTick) {
            this.skipNextTick = false;
            return;
        }
        this.testUngrabMode();
        this.invalidateObjectMouseOver();
        this.resetAllInputs();
        if (ungrab.func_151468_f()) {
            this.doUngrab = true;
        }
        if (this.dead || stop.func_151468_f() || stop.func_151470_d()) {
            this.deactivateCurrentStrategy();
            this.dead = false;
        } else {
            AIStrategy newStrat = this.findNewStrategy();
            if (newStrat != null) {
                this.deactivateCurrentStrategy();
                this.currentStrategy = newStrat;
                System.out.println("Using new root strategy: " + newStrat);
                this.currentStrategy.setActive(true, this);
            }
        }
        if (this.currentStrategy != null) {
            AIStrategy.TickResult result = null;
            for (int i = 0; i < 100 && (result = this.currentStrategy.gameTick(this)) == AIStrategy.TickResult.TICK_AGAIN; ++i) {
            }
            if (result == AIStrategy.TickResult.ABORT || result == AIStrategy.TickResult.NO_MORE_WORK) {
                this.dead = true;
            }
            Object object = this.strategyDescrMutex;
            synchronized (object) {
                this.strategyDescr = this.currentStrategy.getDescription(this);
            }
        }
        Object object = this.strategyDescrMutex;
        synchronized (object) {
            this.strategyDescr = "";
        }
    }

    private void deactivateCurrentStrategy() {
        if (this.currentStrategy != null) {
            this.currentStrategy.setActive(false, this);
        }
        this.currentStrategy = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        if (this.doUngrab) {
            System.out.println("Un-grabbing mouse");
            this.getMinecraft().field_71474_y.field_82881_y = false;
            if (this.getMinecraft().field_71415_G) {
                this.startUngrabMode();
            }
            this.doUngrab = false;
        }
        try {
            String[] str;
            Constructor<?> method = ScaledResolution.class.getConstructors()[0];
            Minecraft arg1 = method.getParameterTypes()[0] == Minecraft.class ? this.getMinecraft() : this.getMinecraft().field_71474_y;
            ScaledResolution res = (ScaledResolution)method.newInstance(arg1, this.getMinecraft().field_71443_c, this.getMinecraft().field_71440_d);
            Object object = this.strategyDescrMutex;
            synchronized (object) {
                str = (this.strategyDescr == null ? "?" : this.strategyDescr).split("\n");
            }
            int y = 10;
            for (String s : str) {
                this.getMinecraft().field_71466_p.func_78261_a(s, res.func_78326_a() - this.getMinecraft().field_71466_p.func_78256_a(s) - 10, y, 0xFFFFFF);
                y += 15;
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private synchronized void startUngrabMode() {
        this.getMinecraft().field_71417_B.func_74373_b();
        this.getMinecraft().field_71415_G = true;
        this.oldMouseHelper = this.getMinecraft().field_71417_B;
        this.getMinecraft().field_71417_B = new MouseHelper(){

            public void func_74374_c() {
            }

            public void func_74372_a() {
            }

            public void func_74373_b() {
            }
        };
    }

    private synchronized void testUngrabMode() {
        if (this.oldMouseHelper != null && this.userTookOver()) {
            System.out.println("Preparing to re-grab the mouse.");
            this.getMinecraft().field_71417_B = this.oldMouseHelper;
            this.getMinecraft().field_71415_G = false;
            this.getMinecraft().func_71381_h();
            this.oldMouseHelper = null;
        }
    }

    @SubscribeEvent
    public void resetOnGameEnd(GuiOpenEvent unload) {
        if (unload.gui instanceof GuiMainMenu) {
            System.out.println("Unloading world.");
            this.dead = true;
            this.buildManager.reset();
        }
    }

    @SubscribeEvent
    public void drawMarkers(RenderWorldLastEvent event) {
        EntityLivingBase player = this.getMinecraft().field_71451_h;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151053_p) {
            if (this.markerRenderer == null) {
                this.markerRenderer = new PosMarkerRenderer(1.0f, 0.0f, 0.0f);
            }
            this.markerRenderer.render(event, this, this.pos1, this.pos2);
        } else if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151055_y) {
            if (this.buildMarkerRenderer == null) {
                this.buildMarkerRenderer = new BuildMarkerRenderer();
            }
            this.buildMarkerRenderer.render(event, this);
        }
        if (this.currentStrategy instanceof MarkingStrategy) {
            ((MarkingStrategy)((Object)this.currentStrategy)).drawMarkers(event, this);
        }
    }

    public void positionMarkEvent(int x, int y, int z, int side) {
        Pos pos = new Pos(x, y, z);
        this.setPosition(pos, this.nextPosIsPos2);
        this.nextPosIsPos2 ^= true;
    }

    private AIStrategy findNewStrategy() {
        if (this.requestedStrategy != null) {
            AIStrategy r = this.requestedStrategy;
            this.requestedStrategy = null;
            return r;
        }
        for (Map.Entry<KeyBinding, AIStrategyFactory> e : uses.entrySet()) {
            AIStrategy strat;
            if (!e.getKey().func_151468_f() || (strat = e.getValue().produceStrategy(this)) == null) continue;
            return strat;
        }
        return null;
    }

    @Override
    public AIHelper getAiHelper() {
        return this;
    }

    @Override
    public void requestUseStrategy(AIStrategy strategy) {
        System.out.println("Request to use " + strategy);
        this.requestedStrategy = strategy;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void playerInteract(PlayerInteractEvent event) {
        ItemStack stack = event.entityPlayer.field_71071_by.func_70448_g();
        if (stack != null && stack.func_77973_b() == Items.field_151053_p && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.field_70170_p.field_72995_K) {
            this.positionMarkEvent(event.x, event.y, event.z, 0);
        }
    }

    public void initialize() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    static {
        ClientRegistry.registerKeyBinding((KeyBinding)stop);
        ClientRegistry.registerKeyBinding((KeyBinding)ungrab);
    }
}

