/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot;

import net.minecraftforge.common.util.ForgeDirection;

public class Pos {
    public int x;
    public int y;
    public int z;

    public Pos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toString() {
        return "Pos [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pos other = (Pos)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public static Pos fromDir(ForgeDirection dir) {
        return new Pos(dir.offsetX, dir.offsetY, dir.offsetZ);
    }

    public Pos add(int x, int y, int z) {
        return new Pos(this.x + x, this.y + y, this.z + z);
    }

    public static Pos[] fromDir(ForgeDirection[] standable) {
        Pos[] res = new Pos[standable.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = Pos.fromDir(standable[i]);
        }
        return res;
    }

    public static Pos minPos(Pos p1, Pos p2) {
        return new Pos(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.min(p1.z, p2.z));
    }

    public static Pos maxPos(Pos p1, Pos p2) {
        return new Pos(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y), Math.max(p1.z, p2.z));
    }

    public Pos add(Pos pos) {
        return this.add(pos.x, pos.y, pos.z);
    }

    public Pos subtract(Pos pos) {
        return new Pos(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }

    public Pos multiply(int howMuch) {
        return new Pos(this.x * howMuch, this.y * howMuch, this.z * howMuch);
    }

    public double distance(Pos other) {
        return Math.hypot(Math.hypot(other.x - this.x, other.y - this.y), other.z - this.z);
    }
}

