/*
 * Decompiled with CFR 0.152.
 */
package net.famzangl.minecraft.minebot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;

public class MinebotSettings {
    private Properties settings;
    private ArrayList<String> keys;
    private static Object mutex = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getSettings() {
        if (this.settings == null) {
            File settingsFile;
            Object object = mutex;
            synchronized (object) {
                settingsFile = this.getSettingsFile();
            }
            this.settings = new Properties();
            try {
                System.out.println("Loading " + settingsFile.getAbsolutePath() + " ...");
                this.settings.load(new FileInputStream(settingsFile));
            }
            catch (IOException e) {
                System.err.println("Could not read settings file.");
            }
        }
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getSettingsFile() {
        File settingsFile = new File(Minecraft.func_71410_x().field_71412_D, "minebot.properties");
        if (!settingsFile.exists()) {
            System.out.println("Settings file " + settingsFile.getAbsolutePath() + " does not exist. Copying default settings.");
            InputStream source = null;
            FileOutputStream destination = null;
            try {
                settingsFile.createNewFile();
                source = this.getClass().getResourceAsStream("minebot.properties");
                destination = new FileOutputStream(settingsFile);
                IOUtils.copy((InputStream)source, (OutputStream)destination);
            }
            catch (IOException e) {
                System.err.println("Error copying default settings.");
                settingsFile.delete();
            }
            catch (NullPointerException e) {
                System.err.println("Could not find default settings.");
                settingsFile.delete();
            }
            finally {
                if (source != null) {
                    try {
                        source.close();
                    }
                    catch (IOException e) {}
                }
                if (destination != null) {
                    try {
                        destination.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return settingsFile;
    }

    public String get(String key, String defaultValue) {
        String property = this.getSettings().getProperty(key);
        return property == null ? defaultValue : property;
    }

    public int getInt(String key, int defaultValue) {
        String property = this.getSettings().getProperty(key);
        try {
            return Integer.parseInt(property);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        String property = this.getSettings().getProperty(key);
        try {
            return Float.parseFloat(property);
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public float getFloat(String string, float defaultValue, float min, float max) {
        return Math.max(min, Math.min(max, this.getFloat(string, defaultValue)));
    }

    public Collection<String> getKeys() {
        if (this.keys == null) {
            this.keys = new ArrayList();
            for (Object k : this.getSettings().keySet()) {
                this.keys.add((String)k);
            }
        }
        return this.keys;
    }
}

