/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.plugin.Blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Random;
import kamkeel.plugin.Blocks.ModBlocks;
import kamkeel.plugin.Compat.CompatibilityBiomesOPlenty;
import kamkeel.plugin.PluginMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockPlugSlab
extends BlockSlab {
    public String name;
    private static final String[] regular = new String[]{"barrel"};
    private static final String[] bop = new String[]{"limestone", "limestonesmooth", "siltstone", "siltstonesmooth", "shale", "shalesmooth"};
    private IIcon[] textures;
    private final SlabCategory category;

    public BlockPlugSlab(boolean isDoubleSlab, Material material, SlabCategory cat) {
        super(isDoubleSlab, material);
        this.category = cat;
        if (material == Material.field_151575_d) {
            this.func_149711_c(2.0f);
            this.func_149752_b(5.0f);
            this.func_149672_a(Block.field_149766_f);
        } else if (material == Material.field_151576_e) {
            this.setHarvestLevel("pickaxe", 0);
            this.func_149711_c(1.8f);
            this.func_149672_a(field_149769_e);
        }
        if (!isDoubleSlab) {
            this.func_149647_a(PluginMod.blocksTab);
        }
        this.field_149783_u = true;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        if (this.category == SlabCategory.REGULAR) {
            this.textures = new IIcon[regular.length];
            for (int i = 0; i < regular.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("plug:" + regular[i]);
            }
        } else {
            this.textures = new IIcon[bop.length];
            for (int i = 0; i < bop.length; ++i) {
                this.textures[i] = iconRegister.func_94245_a("biomesoplenty:" + bop[i]);
            }
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (this.category == SlabCategory.REGULAR) {
            return this.textures[this.getRegularType(meta)];
        }
        return this.textures[this.getBOPType(meta)];
    }

    public void func_149666_a(Item block, CreativeTabs creativeTabs, List list) {
        int max = 0;
        if (this.category == SlabCategory.REGULAR) {
            max = 1;
        } else if (this.category == SlabCategory.BOP) {
            max = 6;
        }
        for (int i = 0; i < max; ++i) {
            list.add(new ItemStack(block, 1, i));
        }
    }

    public String func_150002_b(int meta) {
        if (this.category == SlabCategory.REGULAR) {
            return regular[this.getRegularType(meta)];
        }
        return bop[this.getBOPType(meta)];
    }

    public int func_149692_a(int meta) {
        return meta & 7;
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        if (this.field_150004_a) {
            if (this == ModBlocks.regularDoubleSlab) {
                return Item.func_150898_a((Block)ModBlocks.regularSingleSlab);
            }
            return Item.func_150898_a((Block)CompatibilityBiomesOPlenty.bopSingleSlab);
        }
        return Item.func_150898_a((Block)this);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        float hardness = this.field_149782_v;
        if (this.category == SlabCategory.REGULAR) {
            switch (BlockPlugSlab.getTypeFromMeta(meta)) {
                case 0: 
                case 3: {
                    hardness = 1.6f;
                    break;
                }
                case 1: 
                case 4: {
                    hardness = 1.1f;
                    break;
                }
                case 2: {
                    hardness = 1.0f;
                }
            }
        }
        return hardness;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        BlockPlugSlab block = !this.field_150004_a ? this : (this == ModBlocks.regularDoubleSlab ? ModBlocks.regularSingleSlab : CompatibilityBiomesOPlenty.bopSingleSlab);
        return new ItemStack((Block)block, 1, world.func_72805_g(x, y, z));
    }

    protected ItemStack func_149644_j(int meta) {
        return new ItemStack((Block)this, 2, meta);
    }

    private int getBOPType(int meta) {
        if ((meta = BlockPlugSlab.getTypeFromMeta(meta)) < bop.length) {
            return meta;
        }
        return 0;
    }

    private int getRegularType(int meta) {
        if ((meta = BlockPlugSlab.getTypeFromMeta(meta)) < regular.length) {
            return meta;
        }
        return 0;
    }

    private static int getTypeFromMeta(int meta) {
        return meta & 7;
    }

    public static Block registerBlock(Block block) {
        GameRegistry.registerBlock((Block)block, (String)block.func_149739_a().replace("tile.", "").replace("plug:", ""));
        return block;
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> itemBlockClass, Object ... constructorArgs) {
        GameRegistry.registerBlock((Block)block, itemBlockClass, (String)block.func_149739_a().replace("tile.", "").replace("plug:", ""), (Object[])constructorArgs);
        return block;
    }

    public static enum SlabCategory {
        REGULAR,
        BOP;

    }
}

