/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.plugin.Blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import kamkeel.plugin.Blocks.ItemBlock.ItemBlockConcrete;
import kamkeel.plugin.Entity.EntityFallingConcretePowderBlock;
import kamkeel.plugin.PluginMod;
import kamkeel.plugin.Util.ColorUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockConcretePowder
extends BlockFalling {
    public static final int META_MAX = 27;
    public final int META_AMOUNT;
    public final int META_SET;
    public final String blockName;
    public final Block concrete;
    private IIcon[] iicons;
    public static boolean fallInstantly;

    public BlockConcretePowder(int metaSet, String blockName, Block concrete) {
        super(Material.field_151595_p);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149776_m);
        this.func_149647_a(PluginMod.blocksTab);
        this.META_SET = metaSet;
        this.META_AMOUNT = 16 * (this.META_SET + 1) > 27 ? 11 : 15;
        this.blockName = blockName;
        this.concrete = concrete;
        this.iicons = new IIcon[this.META_AMOUNT + 1];
    }

    public void register() {
        this.func_149663_c("plug:" + this.blockName);
        GameRegistry.registerBlock((Block)this, ItemBlockConcrete.class, (String)this.blockName, (Object[])new Object[]{this.META_SET});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        for (int meta = 0; meta <= this.META_AMOUNT; ++meta) {
            this.iicons[meta] = register.func_94245_a("plug:concrete_powder_" + ColorUtil.concreteToString(meta + 16 * this.META_SET));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.iicons[meta % (this.META_AMOUNT + 1)];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta <= this.META_AMOUNT; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public MapColor func_149728_f(int meta) {
        return ColorUtil.metaToMapColorConcrete(meta + 16 * this.META_SET);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.tryReplaceToConcrete(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        this.tryReplaceToConcrete(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    private boolean tryReplaceToConcrete(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        Block[] aroundBlocks = new Block[]{world.func_147439_a(x + 1, y, z), world.func_147439_a(x - 1, y, z), world.func_147439_a(x, y + 1, z), world.func_147439_a(x, y, z + 1), world.func_147439_a(x, y, z - 1)};
        for (int i = 0; i < 5; ++i) {
            if (aroundBlocks[i].func_149688_o() != Material.field_151586_h) continue;
            world.func_147465_d(x, y, z, this.concrete, meta, 3);
            return true;
        }
        return false;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            this.dropBlockFrom(world, x, y, z);
        }
    }

    private void dropBlockFrom(World world, int x, int y, int z) {
        if (BlockConcretePowder.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y >= 0) {
            int range = 32;
            if (!fallInstantly && world.func_72904_c(x - range, y - range, z - range, x + range, y + range, z + range)) {
                if (!world.field_72995_K) {
                    double posX = (float)x + 0.5f;
                    double posY = (float)y + 0.5f;
                    double posZ = (float)z + 0.5f;
                    int meta = world.func_72805_g(x, y, z);
                    EntityFallingConcretePowderBlock entityfallingblock = new EntityFallingConcretePowderBlock(world, posX, posY, posZ, (Block)this, meta);
                    this.func_149829_a(entityfallingblock);
                    world.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                world.func_147468_f(x, y, z);
                while (BlockConcretePowder.func_149831_e((World)world, (int)x, (int)(y - 1), (int)z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    world.func_147449_b(x, y, z, (Block)this);
                }
            }
        }
    }

    public static boolean shouldNotStopFalling(World world, int x, int y, int z) {
        Block blockUnder = world.func_147439_a(x, y, z);
        return blockUnder.isAir((IBlockAccess)world, x, y, z) || blockUnder == Blocks.field_150480_ab || blockUnder.func_149688_o() == Material.field_151587_i || blockUnder.func_149688_o() == Material.field_151586_h;
    }
}

